import { ItemStack, world } from "@minecraft/server";

world.afterEvents.playerSpawn.subscribe((data) => {
    const { player, initialSpawn } = data;
    if (!initialSpawn) return;

    /** @type {import("@minecraft/server").Container} */
    const container = player.getComponent("inventory").container;
    container.clearAll();

    const item = new ItemStack("minecraft:arrow", 1);
    item.nameTag = "§2Particle Generator";
    item.setLore(["§gRight Click to", "§gCreate Particles"]);
    container.addItem(item);
})

world.afterEvents.itemUse.subscribe((data) => {
    const { itemStack, source: player } = data;
    if (itemStack.typeId !== "minecraft:arrow") return;
    const headLocation = player.getHeadLocation()
    const viewDirection = player.getViewDirection()

    try {
        const pos = player.dimension.getBlockFromRay(headLocation, viewDirection, {
            "includePassableBlocks": true,
            "includeLiquidBlocks": true,
        })

        player.dimension.spawnParticle("jira:particle", {
            x: pos.block.x + pos.faceLocation.x,
            y: pos.block.y + pos.faceLocation.y,
            z: pos.block.z + pos.faceLocation.z
        })
    } catch (e) {}
})